<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trade extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id', 
        'amount',
        'qty',
        'pair',
        'market',
        'entry_price',
        'exit_price',
        'trade_action',
        'entry_time',
        'exit_time',
        'pnl',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
